package ru.yandex.direct.jobs.moderation.reader.support;

import com.google.common.base.Preconditions;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.callout.CalloutModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;

import static ru.yandex.direct.core.entity.moderation.model.ModerationDecision.No;
import static ru.yandex.direct.core.entity.moderation.model.ModerationDecision.Yes;

@Component
public class CalloutModerationResponseConverter extends ModerationResponseConverter<CalloutModerationResponse> {

    @Override
    public ModerationObjectType getType() {
        return ModerationObjectType.CALLOUT;
    }

    @Override
    public Class<CalloutModerationResponse> getClassToConvert() {
        return CalloutModerationResponse.class;
    }

    @Override
    protected void checkValidJson(CalloutModerationResponse r) {
        Preconditions.checkNotNull(r, "response is empty");

        Preconditions.checkNotNull(r.getMeta(), "meta is empty");

        Preconditions.checkArgument(r.getMeta().getCalloutId() != null, "calloutId is null");
        Preconditions.checkArgument(r.getMeta().getCalloutId() != 0, "calloutId is empty");
        Preconditions.checkArgument(r.getMeta().getClientId() != 0, "clientId is empty");
        Preconditions.checkArgument(r.getMeta().getUid() != 0, "uid is empty");
        Preconditions.checkArgument(r.getMeta().getVersionId()  >= 0, "versionId less than zero");

        Preconditions.checkNotNull(r.getResult(), "result is empty");

        Preconditions.checkNotNull(r.getResult().getVerdict(), "verdict is empty");
        Preconditions.checkArgument(
                r.getResult().getVerdict() == Yes ||
                        r.getResult().getVerdict() == No,
                "verdict invalid value");
    }
}
