package ru.yandex.direct.jobs.moderation.reader.support;

import com.google.common.base.Preconditions;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.displayhrefs.DisplayHrefsModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;

import static ru.yandex.direct.core.entity.moderation.model.ModerationDecision.No;
import static ru.yandex.direct.core.entity.moderation.model.ModerationDecision.Yes;

@Component
public class DisplayhrefsModerationResponseConverter extends ModerationResponseConverter<DisplayHrefsModerationResponse> {

    @Override
    public ModerationObjectType getType() {
        return ModerationObjectType.DISPLAYHREFS;
    }

    @Override
    public Class<DisplayHrefsModerationResponse> getClassToConvert() {
        return DisplayHrefsModerationResponse.class;
    }

    @Override
    protected void checkValidJson(DisplayHrefsModerationResponse r) {
        Preconditions.checkNotNull(r, "response is empty");

        Preconditions.checkNotNull(r.getMeta(), "meta is empty");

        Preconditions.checkArgument(r.getMeta().getClientId() != 0, "clientId is empty");
        Preconditions.checkArgument(r.getMeta().getBannerId() != 0, "bid is empty");
        Preconditions.checkArgument(r.getMeta().getUid() != 0, "uid is empty");
        Preconditions.checkArgument(r.getMeta().getVersionId()  >= 0, "versionId less than zero");
        Preconditions.checkArgument(r.getMeta().getDisplayHrefId() != 0, "displayHrefId is empty");

        Preconditions.checkNotNull(r.getResult(), "result is empty");

        Preconditions.checkNotNull(r.getResult().getVerdict(), "verdict is empty");
        Preconditions.checkArgument(
                r.getResult().getVerdict() == Yes ||
                        r.getResult().getVerdict() == No,
                "verdict invalid value");
    }
}
