package ru.yandex.direct.jobs.moderation.reader.support;

import com.google.common.base.Preconditions;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.ModerationDecision;
import ru.yandex.direct.core.entity.moderation.model.image.ImageModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;

@Component
public class ImageModerationResponseConverter extends ModerationResponseConverter<ImageModerationResponse> {

    @Override
    public ModerationObjectType getType() {
        return ModerationObjectType.IMAGES;
    }

    @Override
    public Class<ImageModerationResponse> getClassToConvert() {
        return ImageModerationResponse.class;
    }

    @Override
    protected void checkValidJson(ImageModerationResponse r) {
        Preconditions.checkNotNull(r, "response is empty");

        Preconditions.checkNotNull(r.getMeta(), "meta is empty");

        Preconditions.checkArgument(r.getMeta().getClientId() != 0, "clientId is empty");
        Preconditions.checkArgument(r.getMeta().getBannerId() != 0, "bid is empty");
        Preconditions.checkArgument(r.getMeta().getUid() != 0, "uid is empty");
        Preconditions.checkArgument(r.getMeta().getVersionId()  >= 0, "versionId less than zero");


        Preconditions.checkNotNull(r.getResult(), "result is empty");

        Preconditions.checkNotNull(r.getResult().getVerdict(), "verdict is empty");
        Preconditions.checkArgument(
                r.getResult().getVerdict() == ModerationDecision.Yes ||
                        r.getResult().getVerdict() == ModerationDecision.No,
                "verdict invalid value");
    }
}
