package ru.yandex.direct.jobs.moderation.reader.support;

import com.google.common.base.Preconditions;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.mobilecontenticon.MobileContentIconModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;

import static ru.yandex.direct.core.entity.moderation.model.ModerationDecision.No;
import static ru.yandex.direct.core.entity.moderation.model.ModerationDecision.Yes;

@Component
public class MobileContentIconModerationResponseConverter
        extends ModerationResponseConverter<MobileContentIconModerationResponse> {
    @Override
    public ModerationObjectType getType() {
        return ModerationObjectType.MOBILE_CONTENT_ICON;
    }

    @Override
    public Class<MobileContentIconModerationResponse> getClassToConvert() {
        return MobileContentIconModerationResponse.class;
    }

    @Override
    protected void checkValidJson(MobileContentIconModerationResponse r) {
        Preconditions.checkNotNull(r, "response is empty");

        Preconditions.checkNotNull(r.getMeta(), "meta is empty");

        Preconditions.checkArgument(r.getMeta().getMobileContentId() != null,
                "mobile_content_id is null");
        Preconditions.checkArgument(r.getMeta().getMobileContentId() != 0,
                "mobile_content_id is empty");
        Preconditions.checkArgument(r.getMeta().getClientId() != 0,
                "clientId is empty");
        Preconditions.checkArgument(r.getMeta().getUid() != 0, "uid is empty");
        Preconditions.checkArgument(r.getMeta().getVersionId() >= 0, "versionId less than zero");

        Preconditions.checkNotNull(r.getResult(), "result is empty");

        Preconditions.checkNotNull(r.getResult().getVerdict(), "verdict is empty");
        Preconditions.checkArgument(
                r.getResult().getVerdict() == Yes ||
                        r.getResult().getVerdict() == No,
                "verdict invalid value");
    }
}
