package ru.yandex.direct.jobs.moderation.reader.support;

import com.fasterxml.jackson.databind.JsonNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.core.entity.moderation.model.AbstractModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;
import ru.yandex.direct.utils.JsonUtils;

public abstract class ModerationResponseConverter<T extends AbstractModerationResponse> {
    private static final Logger logger = LoggerFactory.getLogger(ModerationResponseConverter.class);

    /**
     * Тип преобразуется из AbstractModerationResponse.getType()
     * Если тип не известен, то устанавливается ModerationType.UNKNOWN
     */
    public abstract ModerationObjectType getType();

    /**
     * @return класс к которому необходимо сконвертировать вердикт модерации.
     */
    public abstract Class<T> getClassToConvert();

    /**
     * Список проверок валидности полученного объекта
     * Если проверка не проходит, то такой вердик пропускается и пишется в лог
     */
    protected abstract void checkValidJson(T r);

    /**
     * Парсинг вердикта модерации.
     * При ошибках логирует и возвращает null
     */
    public T parseWithoutException(JsonNode json) {
        try {
            T response = JsonUtils.fromJson(json, getClassToConvert());
            checkValidJson(response);

            return response;
        } catch (Exception e) {
            logger.warn("Invalid json {}", json, e);

            return null;
        }
    }
}
