package ru.yandex.direct.jobs.moderation.reader.support

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.moderation.model.ModerationDecision
import ru.yandex.direct.core.entity.moderation.model.promoextension.PromoExtensionModerationResponse
import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType

@Component
class PromoExtensionModerationResponseConverter : ModerationResponseConverter<PromoExtensionModerationResponse>() {
    override fun getType() = ModerationObjectType.PROMO_EXTENSION

    override fun getClassToConvert() = PromoExtensionModerationResponse::class.java

    override fun checkValidJson(r: PromoExtensionModerationResponse?) {
        requireNotNull(r) { "response is empty" }

        requireNotNull(r.meta) { "meta is empty" }

        requireNotNull(r.meta!!.promoExtensionId) { "promoExtensionId is null" }
        require(r.meta!!.promoExtensionId != 0L) { "promoExtensionId is empty" }
        require(r.meta!!.clientId != 0L) { "clientId is empty" }
        require(r.meta!!.uid != 0L) { "uid is empty" }
        require(r.meta!!.versionId >= 0) { "versionId less than zero" }

        requireNotNull(r.result) { "result is empty" }
        requireNotNull(r.result!!.verdict) { "verdict is empty" }
        require(r.result!!.verdict == ModerationDecision.Yes ||
            r.result!!.verdict == ModerationDecision.No) { "verdict invalid value" }
    }
}
