package ru.yandex.direct.jobs.moderation.reader.support;

import com.google.common.base.Preconditions;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.sitelinks.SitelinksModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;

import static ru.yandex.direct.core.entity.moderation.model.ModerationDecision.No;
import static ru.yandex.direct.core.entity.moderation.model.ModerationDecision.Yes;


@Component
public class SitelinksModerationResponseConverter extends ModerationResponseConverter<SitelinksModerationResponse> {

    @Override
    public ModerationObjectType getType() {
        return ModerationObjectType.SITELINKS_SET;
    }

    @Override
    public Class<SitelinksModerationResponse> getClassToConvert() {
        return SitelinksModerationResponse.class;
    }

    @Override
    protected void checkValidJson(SitelinksModerationResponse r) {
        Preconditions.checkNotNull(r, "response is empty");

        Preconditions.checkNotNull(r.getMeta(), "meta is empty");

        Preconditions.checkArgument(r.getMeta().getClientId() != 0, "clientId is empty");
        Preconditions.checkArgument(r.getMeta().getBannerId() != 0, "bid is empty");
        Preconditions.checkArgument(r.getMeta().getUid() != 0, "uid is empty");
        Preconditions.checkArgument(r.getMeta().getVersionId()  >= 0, "versionId less than zero");
        Preconditions.checkArgument(r.getMeta().getSitelinksSetId() != 0, "SitelinkSetId is empty");

        Preconditions.checkNotNull(r.getResult(), "result is empty");

        Preconditions.checkNotNull(r.getResult().getVerdict(), "verdict is empty");
        Preconditions.checkArgument(
                r.getResult().getVerdict() == Yes ||
                        r.getResult().getVerdict() == No,
                "verdict invalid value");
    }
}
