package ru.yandex.direct.jobs.moneyoutreminder;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

import javax.annotation.Nullable;

import com.google.common.collect.ImmutableMap;

public enum MoneyOutReminderNotificationType {
    THREE_DAYS_OFF(3),
    SEVEN_DAYS_OFF(7);

    public final int days;

    private static final Map<Integer, MoneyOutReminderNotificationType> VALUES_MAP = ImmutableMap.copyOf(
            Arrays.stream(values())
                    .collect(Collectors.toMap(value -> value.days, value -> value)));

    MoneyOutReminderNotificationType(int days) {
        this.days = days;
    }

    static boolean containsDays(int days) {
        return VALUES_MAP.containsKey(days);
    }

    @Nullable
    static MoneyOutReminderNotificationType getByDays(int days) {
        return VALUES_MAP.getOrDefault(days, null);
    }
}
