package ru.yandex.direct.jobs.monitoring.model;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.apache.zookeeper.data.Stat;

/**
 * Абстракция над очередью за ресурсом в switchman
 */
public class SwitchmanResourceQueueSize {
    public static final String DEFAULT_RESOURCE_GROUP = "other";
    private static final int PARTS_NUM = 2;

    private final String[] resourceParts;
    private final String resource;
    private int queueSize;

    /**
     * Сконструировать объект-обертку.
     * <p>
     * Если имя ресурса имеет вид {@literal XX_YY} (через подчеркивание),
     * то в качестве его имени будет взят {@literal XX}, а группы - {@literal YY},
     * иначе - имя останется исходным, а группа будет {@link #DEFAULT_RESOURCE_GROUP}.
     *
     * @param resource имя ресурса
     * @param stat     статистика по ноде в ZooKeeper с указанным ресурсом
     */
    public SwitchmanResourceQueueSize(@Nonnull String resource, @Nullable Stat stat) {
        this.resource = resource;
        this.resourceParts = resource.split("_", PARTS_NUM);
        this.queueSize = stat == null ? 0 : stat.getNumChildren();
    }

    /**
     * Получить исходное имя ресурса
     */
    public String getOriginalResourceName() {
        return resource;
    }

    /**
     * Получить имя ресурса
     */
    public String getResourceName() {
        return resourceParts.length == PARTS_NUM ? resourceParts[0] : resource;
    }

    /**
     * Получить группу ресурса
     */
    public String getResourceGroup() {
        return resourceParts.length == PARTS_NUM ? resourceParts[1] : DEFAULT_RESOURCE_GROUP;
    }

    /**
     * Получить размер очереди на ресурс
     */
    public int getQueueSize() {
        return queueSize;
    }
}
