package ru.yandex.direct.jobs.monitoring.system

import ru.yandex.direct.jobs.monitoring.system.processor.MonitoringDataProcessor
import ru.yandex.direct.jobs.monitoring.system.source.MonitoringData
import ru.yandex.direct.jobs.monitoring.system.source.MonitoringDataSource
import ru.yandex.direct.scheduler.hourglass.TaskParametersMap
import ru.yandex.direct.scheduler.support.DirectParameterizedJob
import ru.yandex.direct.scheduler.support.ParametersSource

abstract class AbstractMonitoringJob<P: ParametersSource<T>, T, S: MonitoringData>(
    private val parameters: P,
    private val sourceType: MonitoringSourceType,
    allDataProcessors: List<MonitoringDataProcessor<out MonitoringData>>,
) : DirectParameterizedJob<T>() {

    abstract val dataSource:  MonitoringDataSource<T, S>

    private val dataProcessors = allDataProcessors
        .filter { processor -> processor.sourceType == sourceType }
        .map { processor -> processor as MonitoringDataProcessor<S> }

    override fun initialize(taskParametersMap: TaskParametersMap) {
        super.initialize(taskParametersMap)

        dataSource.initialize(parameters.convertStringToParam(param))
    }

    override fun execute() {
        dataSource.fetch(dataProcessors)
    }

    override fun finish() {
        dataSource.close()
    }
}
