package ru.yandex.direct.jobs.monitoring.system

import org.springframework.stereotype.Component
import ru.yandex.direct.config.DirectConfig
import ru.yandex.direct.jobs.monitoring.system.source.tracelog.CONFIG_SECTION_NAME
import ru.yandex.direct.scheduler.support.ParametersSource

private const val PREFIX = "group_"

@Component
class TraceLogMonitoringParametersSource(
    private val directConfig: DirectConfig
) : ParametersSource<Int> {
    override fun getAllParamValues(): List<Int> {
        return directConfig.getBranch(CONFIG_SECTION_NAME).getIntList("group")
    }

    override fun convertParamToString(paramValue: Int): String {
        return PREFIX + paramValue
    }

    override fun convertStringToParam(string: String): Int {
        return string.split('_')[1].toInt()
    }
}
