package ru.yandex.direct.jobs.monitoring.system

import org.springframework.context.ApplicationContext
import ru.yandex.direct.env.NonDevelopmentEnvironment
import ru.yandex.direct.env.ProductionOnly
import ru.yandex.direct.jobs.monitoring.system.processor.MonitoringDataProcessor
import ru.yandex.direct.jobs.monitoring.system.source.MonitoringData
import ru.yandex.direct.jobs.monitoring.system.source.MonitoringDataSource
import ru.yandex.direct.jobs.monitoring.system.source.tracelog.TraceLogLogbrokerMonitoringSource
import ru.yandex.direct.jobs.monitoring.system.source.tracelog.TraceLogMonitoringData
import ru.yandex.direct.juggler.check.annotation.JugglerCheck
import ru.yandex.direct.juggler.check.model.CheckTag
import ru.yandex.direct.scheduler.Hourglass
import ru.yandex.direct.scheduler.HourglassDaemon
import ru.yandex.direct.scheduler.support.ParameterizedBy

@JugglerCheck(
    ttl = JugglerCheck.Duration(minutes = 10),
    tags = [CheckTag.DIRECT_PRODUCT_TEAM],
    needCheck = ProductionOnly::class,
)
@HourglassDaemon(runPeriod = 0)
@Hourglass(periodInSeconds = 0, needSchedule = NonDevelopmentEnvironment::class)
@ParameterizedBy(parametersSource = TraceLogMonitoringParametersSource::class)
class TraceLogSystemMonitoringJob(
    private val applicationContext: ApplicationContext,
    parameters: TraceLogMonitoringParametersSource,
    allMonitoringDataProcessors: List<MonitoringDataProcessor<out MonitoringData>>)
    : AbstractMonitoringJob<TraceLogMonitoringParametersSource, Int, TraceLogMonitoringData>(
    parameters, MonitoringSourceType.TRACE_LOG, allMonitoringDataProcessors) {

    override val dataSource: MonitoringDataSource<Int, TraceLogMonitoringData> =
        applicationContext.getBean(TraceLogLogbrokerMonitoringSource::class.java)
}
