package ru.yandex.direct.jobs.monitoring.system.processor

import org.slf4j.Logger
import org.springframework.beans.factory.BeanNameAware
import ru.yandex.direct.jobs.monitoring.system.MonitoringSourceType
import ru.yandex.direct.jobs.monitoring.system.source.MonitoringData
import ru.yandex.monlib.metrics.labels.Labels

const val MONITORING_PREFIX = "monitoring_"
private const val MAX_LABEL_VALUE_LENGTH = 200

interface MonitoringDataProcessor<T : MonitoringData> : BeanNameAware {
    val sourceType: MonitoringSourceType

    fun process(monitoringData: List<T>)

    fun getSensorName(processorName: String): String {
        return processorName.removeSuffix("MonitoringDataProcessor")
    }

    fun getLabels(logger: Logger, key: MonitoringProcessorKey): Labels {
        return Labels.of(MONITORING_PREFIX + "service", prepareLabelName(logger, key.service),
            MONITORING_PREFIX + "method", prepareLabelName(logger, key.method))
    }

    private fun prepareLabelName(logger: Logger, string: String): String {
        if (string.length > MAX_LABEL_VALUE_LENGTH) {
            logger.warn("$string length more than allowed for label name")
            return string.substring(0, MAX_LABEL_VALUE_LENGTH)
        }
        return string
    }
}
