package ru.yandex.direct.jobs.monitoring.system.processor

import ru.yandex.direct.jobs.monitoring.system.MonitoringSourceType
import ru.yandex.direct.jobs.monitoring.system.source.MonitoringData
import ru.yandex.direct.solomon.SolomonUtils
import ru.yandex.monlib.metrics.primitives.Rate

class RateMonitoringProcessor<T : MonitoringData>(
    override val sourceType: MonitoringSourceType,
    checkServices: Set<String>,
) : AbstractMonitoringProcessor<T, MonitoringProcessorKey, Rate>(checkServices) {

    override fun removeMetric(key: MonitoringProcessorKey, metric: Rate) {
        SolomonUtils.LIFELINE_METRICS_REGISTRY.removeMetric(sensorName, getLabels(logger, key))
    }

    override fun loadMetric(key: MonitoringProcessorKey): Rate {
        return SolomonUtils.LIFELINE_METRICS_REGISTRY.rate(sensorName, getLabels(logger, key))
    }

    override fun processMethod(key: MonitoringProcessorKey, dataList: List<T>) {
        val sensor = metrics[key]
        dataList.forEach { _ -> sensor.inc() }
    }
}
