package ru.yandex.direct.jobs.monitoring.system.processor

import ru.yandex.direct.jobs.monitoring.system.MonitoringSourceType
import ru.yandex.direct.jobs.monitoring.system.source.MonitoringData
import ru.yandex.direct.solomon.SolomonUtils
import ru.yandex.monlib.metrics.primitives.Counter
import java.time.LocalDateTime

class StringExistMonitoringProcessor<T : MonitoringData>(
    override val sourceType: MonitoringSourceType,
    checkServices: Set<String>,
    private val exactString: String,
    private val extractFunction: (T) -> Set<String>,
) : AbstractMonitoringProcessor<T, MonitoringProcessorKey, Counter>(checkServices) {

    private val processorLogger: StringProcessorLogger<T> = StringProcessorLogger(logger)

    override fun removeMetric(key: MonitoringProcessorKey, metric: Counter) {
        SolomonUtils.LIFELINE_METRICS_REGISTRY.removeMetric(sensorName, getLabels(logger, key))
    }

    override fun loadMetric(key: MonitoringProcessorKey): Counter {
        return SolomonUtils.LIFELINE_METRICS_REGISTRY.counter(sensorName, getLabels(logger, key))
    }

    override fun processMethod(key: MonitoringProcessorKey,
                               dataList: List<T>) {
        val sensor = metrics[key]

        dataList.forEach { dataRow ->
            val extractResult = extractFunction.invoke(dataRow)
            if (extractResult.contains(exactString)) {
                processorLogger.log(processorName, exactString, dataRow)
                sensor.inc()
            }
        }
    }
}
