package ru.yandex.direct.jobs.monitoring.system.processor

import org.slf4j.Logger
import ru.yandex.direct.jobs.monitoring.system.source.MonitoringData
import java.time.LocalDateTime
import java.util.concurrent.ConcurrentHashMap

class StringProcessorLogger<T : MonitoringData>(
    private val logger: Logger
) {
    //Чтобы не писать много данных в логи, делаем это через 5 секунд, после последней записи.
    //процессор могут использовать несколько инстансов джобы, поэтому ConcurrentHashMap
    private val logCache: MutableMap<LoggerCacheKey, T> = ConcurrentHashMap()
    private var dateTime: LocalDateTime = LocalDateTime.now()

    fun log(processorName: String, searchString: String, dataRow: T) {
        if (LocalDateTime.now() > dateTime.plusSeconds(DEFAULT_LOG_INTERVAL_SECONDS)) {
            synchronized(this) {
                logCache.forEach { (key, value) ->
                    logger.info("$processorName found string $key in row $value")
                }
                logCache.clear()
                dateTime = LocalDateTime.now()
            }
        } else {
            logCache[LoggerCacheKey(searchString, dataRow.method)] = dataRow
        }
    }

    private data class LoggerCacheKey(
        val searchString: String,
        val method: String
    )
}
