package ru.yandex.direct.jobs.monitoring.system.processor

import ru.yandex.direct.jobs.monitoring.system.MonitoringSourceType
import ru.yandex.direct.jobs.monitoring.system.source.MonitoringData
import ru.yandex.direct.solomon.SolomonUtils
import ru.yandex.monlib.metrics.primitives.Counter

class ThresholdMonitoringProcessor<T : MonitoringData, D: Comparable<D>>(
    override val sourceType: MonitoringSourceType,
    checkServices: Set<String>,
    private val threshold: D,
    private val extractFunction: (T) -> D,
) : AbstractMonitoringProcessor<T, MonitoringProcessorKey, Counter>(checkServices) {

    override fun removeMetric(key: MonitoringProcessorKey, metric: Counter) {
        SolomonUtils.LIFELINE_METRICS_REGISTRY.removeMetric(sensorName, getLabels(logger, key))
    }

    override fun loadMetric(key: MonitoringProcessorKey): Counter {
        return SolomonUtils.LIFELINE_METRICS_REGISTRY.counter(sensorName, getLabels(logger, key))
    }

    override fun processMethod(key: MonitoringProcessorKey,
                               dataList: List<T>) {
        val sensor = metrics[key]

        dataList.forEach { dataRow ->
            val extractResult = extractFunction.invoke(dataRow)
            if (extractResult > threshold) {
                logger.info("for data row $dataRow threshold reached")
                sensor.inc()
            }
        }
    }
}
