package ru.yandex.direct.jobs.monitoring.system.processor

import ru.yandex.direct.jobs.monitoring.system.MonitoringSourceType
import ru.yandex.direct.jobs.monitoring.system.source.MonitoringData
import ru.yandex.direct.solomon.SolomonUtils.LIFELINE_METRICS_REGISTRY
import ru.yandex.monlib.metrics.histogram.HistogramCollector
import ru.yandex.monlib.metrics.primitives.Histogram

class TimelineMonitoringProcessor<T : MonitoringData>(
    override val sourceType: MonitoringSourceType,
    checkServices: Set<String>,
    private val extractFunction: (T) -> Double,
    private val doubleToLongMultiplier: Int?,
    private val histogramCollector: () -> HistogramCollector
) : AbstractMonitoringProcessor<T, MonitoringProcessorKey, Histogram>(checkServices) {

    override fun removeMetric(key: MonitoringProcessorKey, metric: Histogram) {
        LIFELINE_METRICS_REGISTRY.removeMetric(sensorName, getLabels(logger, key))
    }

    override fun loadMetric(key: MonitoringProcessorKey): Histogram {
        return LIFELINE_METRICS_REGISTRY.histogramRate(sensorName, getLabels(logger, key), histogramCollector.invoke())
    }

    override fun processMethod(key: MonitoringProcessorKey, dataList: List<T>) {
        val extractedData = dataList
            .map(extractFunction)
            .map { value -> convertToLong(value) }

        val sensor = metrics[key]
        extractedData.forEach { value -> sensor.record(value) }
    }

    private fun convertToLong(value: Double): Long {
        if (doubleToLongMultiplier != null) {
            return (value * doubleToLongMultiplier).toLong()
        } else {
            return value.toLong()
        }
    }
}
