package ru.yandex.direct.jobs.monitoring.system.source

import ru.yandex.direct.jobs.monitoring.system.processor.MonitoringDataProcessor

abstract class AbstractMonitoringSource<P, T : MonitoringData> : MonitoringDataSource<P, T> {

    override fun fetch(monitoringDataProcessors: List<MonitoringDataProcessor<T>>) {
        fetch { data ->
            monitoringDataProcessors.forEach { processor -> processor.process(data) }
        }
    }

    abstract fun fetch(consumer: (List<T>) -> Unit)
}
