package ru.yandex.direct.jobs.monitoring.yt

import org.springframework.stereotype.Component
import ru.yandex.direct.config.DirectConfig
import ru.yandex.direct.scheduler.support.ParametersSource
import ru.yandex.direct.ytwrapper.model.YtCluster

@Component
class YtTablesMonitoringParametersSourceHolder(private val directConfig: DirectConfig) : ParametersSource<YtCluster> {

    private val tablesByCluster: Map<YtCluster, List<YtTablesMonitoringParameter>> = groupTablesByCluster()

    private fun groupTablesByCluster(): Map<YtCluster, List<YtTablesMonitoringParameter>> {
        return directConfig.getConfigList("yt_tables_monitoring")
                .map {
                    YtTablesMonitoringParameter(
                            table = it.getString("table"),
                            clusters = it.getStringList("clusters").map { cluster -> YtCluster.parse(cluster) },
                            lastUpdateAttributeName = it.getString("last_update_attribute_name"),
                            lastUpdateAttributeType = it.getString("last_update_attribute_type"),
                    )
                }
                .map { it.clusters to it }
                .flatMap { (clusters, table) -> clusters.map { it to table } }
                .groupBy({ it.first }, { it.second })
    }

    override fun getAllParamValues(): List<YtCluster> {
        return tablesByCluster.keys.toList()
    }

    override fun convertParamToString(paramValue: YtCluster): String {
        return paramValue.getName()
    }

    override fun convertStringToParam(string: String): YtCluster {
        return YtCluster.parse(string)
    }

    fun getTablesByCluster(cluster: YtCluster): List<YtTablesMonitoringParameter> {
        return tablesByCluster[cluster] ?: throw IllegalStateException("Not found tables for cluster: $cluster")
    }

}
