package ru.yandex.direct.jobs.motivationemail;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.motivationmail.MotivationMailNotificationType;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class MotivationMailEvent {
    @JsonProperty
    private final MotivationEventType reason;

    @JsonProperty
    private final MotivationMailNotificationType notification;

    @JsonProperty
    private final Long clientId;

    @JsonProperty
    private final Long uid;

    @JsonProperty
    private final String templateId;

    public MotivationMailEvent(MotivationEventType reason, Long clientId, Long uid,
                               MotivationMailNotificationType notification, String templateId) {
        this.reason = reason;
        this.clientId = clientId;
        this.uid = uid;
        this.notification = notification;
        this.templateId = templateId;
    }

    public static MotivationMailEvent deletionMotivationFinished(Long clientId) {
        return new MotivationMailEvent(MotivationEventType.DELETION_MOTIVATION_FINISHED, clientId, null, null, null);
    }

    public static MotivationMailEvent mailSent(MotivationMailNotificationType notification, Long clientId, Long uid, String templateId) {
        return new MotivationMailEvent(MotivationEventType.MAIL_SENT, clientId, uid, notification, templateId);
    }

    public static MotivationMailEvent deletionMotivationBadEmail(Long clientId) {
        return new MotivationMailEvent(MotivationEventType.DELETION_BAD_EMAIL, clientId, null, null, null);
    }

    public enum MotivationEventType {
        DELETION_MOTIVATION_FINISHED,
        DELETION_BAD_EMAIL,
        MAIL_SENT
    }
}
