package ru.yandex.direct.jobs.motivationemail;

import java.util.Map;

import ru.yandex.direct.core.entity.motivationmail.MotivationMailNotificationType;
import ru.yandex.direct.core.entity.motivationmail.MotivationMailStats.ClientType;
import ru.yandex.direct.i18n.Language;

public class MotivationMailTemplateResolver {
    private final Map<ClientType, Map<Language, Map<MotivationMailNotificationType, String>>> templateMapping;

    public MotivationMailTemplateResolver(Map<ClientType, Map<Language, Map<MotivationMailNotificationType, String>>> templateMapping) {
        this.templateMapping = templateMapping;
    }

    public String resolveTemplateId(Language lang, ClientType clientType, MotivationMailNotificationType notification) {
        Map<Language, Map<MotivationMailNotificationType, String>> mappingForClientType =
                templateMapping.get(clientType);
        if (mappingForClientType == null) {
            return null;
        }
        Map<MotivationMailNotificationType, String> mappingsForLang = mappingForClientType.get(lang);
        return mappingsForLang == null ? null : mappingsForLang.get(notification);
    }
}
