package ru.yandex.direct.jobs.objectsstats.model;

import java.time.LocalDateTime;

public class CreatedObjectsStat {
    private LocalDateTime datetime;
    private String service;
    private String table;
    private Long count;

    public LocalDateTime getDatetime() {
        return datetime;
    }

    public CreatedObjectsStat withDatetime(LocalDateTime datetime) {
        this.datetime = datetime;
        return this;
    }

    public String getService() {
        return service;
    }

    public CreatedObjectsStat withService(String service) {
        this.service = service;
        return this;
    }

    public String getTable() {
        return table;
    }

    public CreatedObjectsStat withTable(String table) {
        this.table = table;
        return this;
    }

    public Long getCount() {
        return count;
    }

    public CreatedObjectsStat withCount(Long count) {
        this.count = count;
        return this;
    }
}
