package ru.yandex.direct.jobs.objectsstats.service;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

import org.springframework.jdbc.core.RowMapper;

import ru.yandex.direct.jobs.objectsstats.model.CreatedObjectsStat;

import static ru.yandex.direct.jobs.objectsstats.model.BinlogRowsTableInfo.BINLOG_ROWS_COUNT_ALIAS;
import static ru.yandex.direct.jobs.objectsstats.model.BinlogRowsTableInfo.BINLOG_ROWS_DATETIME_START_OF_MINUTE_ALIAS;
import static ru.yandex.direct.jobs.objectsstats.model.BinlogRowsTableInfo.BINLOG_ROWS_SERVICE_COLUMN;
import static ru.yandex.direct.jobs.objectsstats.model.BinlogRowsTableInfo.BINLOG_ROWS_TABLE_COLUMN;


public class CreatedObjectsStatsRowMapper implements RowMapper<CreatedObjectsStat> {
    @Override
    public CreatedObjectsStat mapRow(ResultSet rs, int rowNum) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();

        CreatedObjectsStat createdObjectsStat = new CreatedObjectsStat();

        for (int i = 1; i <= metaData.getColumnCount(); i++) {
            switch (metaData.getColumnName(i)) {
                case BINLOG_ROWS_DATETIME_START_OF_MINUTE_ALIAS:
                    createdObjectsStat.withDatetime(rs.getTimestamp(metaData.getColumnName(i)).toLocalDateTime());
                    break;
                case BINLOG_ROWS_SERVICE_COLUMN:
                    createdObjectsStat.withService(rs.getString(metaData.getColumnName(i)));
                    break;
                case BINLOG_ROWS_TABLE_COLUMN:
                    createdObjectsStat.withTable(rs.getString(metaData.getColumnName(i)));
                    break;
                case BINLOG_ROWS_COUNT_ALIAS:
                    createdObjectsStat.withCount(rs.getLong(metaData.getColumnName(i)));
                    break;
                default:
                    break;
            }
        }

        return createdObjectsStat;
    }
}
