package ru.yandex.direct.jobs.offlinereport.model;

import javax.annotation.Nullable;

import org.apache.commons.lang.RandomStringUtils;

import ru.yandex.direct.core.entity.offlinereport.model.OfflineReportType;
import ru.yandex.direct.jobs.offlinereport.model.agencykpi.AgencyKpiOfflineReportType;

public class OfflineReportHeader {
    private final Long agencyId;//id агентства
    private final String agencyName;//название агентства
    private final String stringFrom;//Начало периода
    private final String stringTo;//Окончание периода
    private final String login;//login пользователя, который формирует отчёт
    private final OfflineReportType reportType;//тип отчета
    private final AgencyKpiOfflineReportType agencyKpiReportType;//подтип отчета по KPI

    public OfflineReportHeader(Long agencyId, String agencyName, String stringFrom, String stringTo, String login,
                               OfflineReportType reportType,
                               @Nullable AgencyKpiOfflineReportType agencyKpiReportType) {
        this.agencyId = agencyId;
        this.agencyName = agencyName;
        this.stringFrom = stringFrom;
        this.stringTo = stringTo;
        this.login = login;
        this.reportType = reportType;
        this.agencyKpiReportType = agencyKpiReportType;
    }

    public Long getAgencyId() {
        return agencyId;
    }

    public String getAgencyName() {
        return agencyName;
    }

    public String getStringFrom() {
        return stringFrom;
    }

    public String getStringTo() {
        return stringTo;
    }

    public String getLogin() {
        return login;
    }

    public OfflineReportType getReportType() {
        return reportType;
    }

    public AgencyKpiOfflineReportType getAgencyKpiReportType() {
        return agencyKpiReportType;
    }

    private String reportTypeString() {
        return reportType == OfflineReportType.AGENCY_KPI
                ? reportType + "_" + agencyKpiReportType
                : reportType.toString();
    }

    public String getFileName() {
        switch (reportType) {
            case DOMAINS:
                return "offline_report_" + getStringFrom() + "_" + getStringTo() + "_" + getLogin()
                        + "_" + RandomStringUtils.randomAlphabetic(4)//чтобы усложнить подбор названия файла на сервере
                        + ".xlsx";
            case AGENCY_KPI:
                return getStringFrom() + "-" + getStringTo() + "-" + getLogin() + "-qkpi-report_"
                        + RandomStringUtils.randomAlphabetic(4)//дабы не было ошибки дублирования названий файлов
                        + ".xlsx";
            default:
                throw new IllegalStateException("Offline reports of type " + reportType + " do not exist");
        }
    }

    @Override
    public String toString() {
        return "OfflineReportHeader{" +
                "agencyId=" + agencyId +
                ", agencyName='" + agencyName + '\'' +
                ", stringFrom='" + stringFrom + '\'' +
                ", stringTo='" + stringTo + '\'' +
                ", reportType='" + reportTypeString() + '\'' +
                '}';
    }
}
