package ru.yandex.direct.jobs.offlinereport.model.agencykpi;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.direct.jobs.offlinereport.model.BaseOfflineReport;
import ru.yandex.direct.jobs.offlinereport.model.OfflineReportHeader;

public class AgencyKpiOfflineReport extends BaseOfflineReport {
    private final List<AgencyKpiOfflineReportCpcRow> cpcRows;
    private List<AgencyKpiOfflineReportMediaRow> mediaRows;

    public AgencyKpiOfflineReport(OfflineReportHeader header,
                                  List<AgencyKpiOfflineReportCpcRow> cpcRows) {
        super(header);
        this.cpcRows = cpcRows;
        this.mediaRows = new ArrayList<>();
    }

    public void setMediaRows(List<AgencyKpiOfflineReportMediaRow> mediaRows) {
        this.mediaRows = mediaRows;
    }

    public List<AgencyKpiOfflineReportCpcRow> getCpcRows() {
        return cpcRows;
    }

    public List<AgencyKpiOfflineReportMediaRow> getMediaRows() {
        return mediaRows;
    }
}
