package ru.yandex.direct.jobs.offlinereport.model.agencykpi;

import java.math.BigDecimal;

/**
 * Общие поля для строк на вкладках "Покликовые кампании" и "Медийные кампании" KPI отчета.
 */
public abstract class AgencyKpiOfflineReportBaseRow {
    private final String contractEids;//номера договоров
    private final Long clientId;//id клиента
    private final String clientLogin;//логин клиента
    private final String clientName;//имя клиента
    private final String representativeLogin;//логин представителя
    private final Long cid;//id кампании
    private final String campaignName;//имя кампании
    private final BigDecimal totalAmount;//оборот РК всего

    public AgencyKpiOfflineReportBaseRow(String contractEids,
                                         Long clientId, String clientLogin, String clientName,
                                         String representativeLogin,
                                         Long cid, String campaignName, BigDecimal totalAmount) {
        this.contractEids = contractEids;
        this.clientId = clientId;
        this.clientLogin = clientLogin;
        this.clientName = clientName;
        this.representativeLogin = representativeLogin;
        this.cid = cid;
        this.campaignName = campaignName;
        this.totalAmount = totalAmount;
    }

    public String getContractEids() {
        return contractEids;
    }

    public Long getClientId() {
        return clientId;
    }

    public String getClientLogin() {
        return clientLogin;
    }

    public String getClientName() {
        return clientName;
    }

    public String getRepresentativeLogin() {
        return representativeLogin;
    }

    public Long getCid() {
        return cid;
    }

    public String getCampaignName() {
        return campaignName;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }
}
