package ru.yandex.direct.jobs.offlinereport.model.agencykpi;

import java.math.BigDecimal;

/**
 * Поля для строк на вкладке "Покликовые кампании" KPI отчета.
 */
public class AgencyKpiOfflineReportCpcRow extends AgencyKpiOfflineReportBaseRow {
    private final BigDecimal rsyaAmount;//оборот в РСЯ
    private final BigDecimal rsyaRate;//Доля РСЯ в обороте
    private final String domainName;//имя домена
    private final String domainTotalAmount;//оборот всего по доменам (по РК)
    private final String domainRsyaAmount;//оборот в РСЯ по доменам (по РК)
    private final String domainRsyaRate;//Доля РСЯ в обороте по доменам (по агентству)
    private final String countersRate;//номера счетчиков Метрики и их доля покрытия
    private final String goalsRate;//номера ключевых целей и их доля покрытия
    private final String clickVisitRate;//общая доля кликов (Метрика)
    private final BigDecimal metrikaAmount;//оборот РК со счетчиками Метрики, прошедшими проверку
    private final BigDecimal metrikaAndGoalsAmount;//оборот РК с целями Метрики, прошедшими проверку
    private final BigDecimal autobudgetAmount;//оборот автостратегий
    private final BigDecimal cpcVideoAmount;//оборот видеообъявление и видеодополнений
    private final BigDecimal mobileContentAmount;//оборот РМП
    private final BigDecimal performanceAmount;//оборот смарт-баннеров
    private final BigDecimal productGalleryAmount;//оборот товарной галереи
    private final String k50EffectiveActionsRate;//доля эффективных действий К50 (по агентству)
    private final String k50EfficientAmount;//оборот К50 (по логину)
    private final BigDecimal retargetingAmount;//оборот ретаргетинга
    private final BigDecimal autotargetSearchAmount;//оборот автотаргетинга на поиске

    private AgencyKpiOfflineReportCpcRow(String contractEids,
                                         Long clientId, String clientLogin, String clientName,
                                         String representativeLogin,
                                         Long cid, String campaignName, BigDecimal totalAmount,
                                         BigDecimal rsyaAmount, BigDecimal rsyaRate,
                                         String domainName,
                                         String domainTotalAmount, String domainRsyaAmount, String domainRsyaRate,
                                         String countersRate, String goalsRate, String clickVisitRate,
                                         BigDecimal metrikaAmount, BigDecimal metrikaAndGoalsAmount,
                                         BigDecimal autobudgetAmount,
                                         BigDecimal cpcVideoAmount,
                                         BigDecimal mobileContentAmount,
                                         BigDecimal performanceAmount,
                                         BigDecimal productGalleryAmount,
                                         String k50EffectiveActionsRate, String k50EfficientAmount,
                                         BigDecimal retargetingAmount,
                                         BigDecimal autotargetSearchAmount) {
        super(contractEids, clientId, clientLogin, clientName, representativeLogin,
                cid, campaignName, totalAmount);

        this.rsyaAmount = rsyaAmount;
        this.rsyaRate = rsyaRate;

        this.domainName = domainName;
        this.domainTotalAmount = domainTotalAmount;
        this.domainRsyaAmount = domainRsyaAmount;
        this.domainRsyaRate = domainRsyaRate;

        this.countersRate = countersRate;
        this.goalsRate = goalsRate;
        this.clickVisitRate = clickVisitRate;
        this.metrikaAmount = metrikaAmount;
        this.metrikaAndGoalsAmount = metrikaAndGoalsAmount;
        this.autobudgetAmount = autobudgetAmount;

        this.cpcVideoAmount = cpcVideoAmount;
        this.mobileContentAmount = mobileContentAmount;
        this.performanceAmount = performanceAmount;
        this.productGalleryAmount = productGalleryAmount;

        this.k50EffectiveActionsRate = k50EffectiveActionsRate;
        this.k50EfficientAmount = k50EfficientAmount;
        this.retargetingAmount = retargetingAmount;
        this.autotargetSearchAmount = autotargetSearchAmount;
    }

    /**
     * Конструктор для агентств со старым типом Премиум.
     * <p>
     * Будет удален (как и сам тип PREMIUM_OLD) в марте - DIRECT-162758.
     */
    public AgencyKpiOfflineReportCpcRow(String contractEids,
                                        Long clientId, String clientLogin, String clientName,
                                        String representativeLogin,
                                        Long cid, String campaignName, BigDecimal totalAmount,
                                        String countersRate, String goalsRate, String clickVisitRate,
                                        BigDecimal metrikaAmount, BigDecimal metrikaAndGoalsAmount,
                                        BigDecimal autobudgetAmount,
                                        BigDecimal cpcVideoAmount,
                                        BigDecimal mobileContentAmount,
                                        BigDecimal performanceAmount,
                                        String k50EffectiveActionsRate, String k50EfficientAmount,
                                        BigDecimal retargetingAmount) {
        this(contractEids, clientId, clientLogin, clientName, representativeLogin,
                cid, campaignName, totalAmount,
                null, null,
                null, null, null, null,
                countersRate, goalsRate, clickVisitRate, metrikaAmount, metrikaAndGoalsAmount, autobudgetAmount,
                cpcVideoAmount, mobileContentAmount, performanceAmount, null,
                k50EffectiveActionsRate, k50EfficientAmount, retargetingAmount, null);
    }

    /**
     * Конструктор для агентств с типом Премиум или Агрегатор.
     */
    public AgencyKpiOfflineReportCpcRow(String contractEids,
                                        Long clientId, String clientLogin, String clientName,
                                        String representativeLogin,
                                        Long cid, String campaignName, BigDecimal totalAmount,
                                        String domainName,
                                        String domainTotalAmount, String domainRsyaAmount, String domainRsyaRate,
                                        String countersRate, String goalsRate, String clickVisitRate,
                                        BigDecimal metrikaAmount, BigDecimal metrikaAndGoalsAmount,
                                        BigDecimal autobudgetAmount,
                                        BigDecimal cpcVideoAmount,
                                        BigDecimal mobileContentAmount,
                                        BigDecimal performanceAmount,
                                        BigDecimal productGalleryAmount,
                                        String k50EffectiveActionsRate, String k50EfficientAmount,
                                        BigDecimal retargetingAmount,
                                        BigDecimal autotargetSearchAmount) {
        this(contractEids, clientId, clientLogin, clientName, representativeLogin,
                cid, campaignName, totalAmount,
                null, null,
                domainName, domainTotalAmount, domainRsyaAmount, domainRsyaRate,
                countersRate, goalsRate, clickVisitRate, metrikaAmount, metrikaAndGoalsAmount, autobudgetAmount,
                cpcVideoAmount, mobileContentAmount, performanceAmount, productGalleryAmount,
                k50EffectiveActionsRate, k50EfficientAmount, retargetingAmount, autotargetSearchAmount);
    }

    /**
     * Конструктор для агентств с типом База.
     */
    public AgencyKpiOfflineReportCpcRow(String contractEids,
                                        Long clientId, String clientLogin, String clientName,
                                        String representativeLogin,
                                        Long cid, String campaignName, BigDecimal totalAmount,
                                        BigDecimal rsyaAmount, BigDecimal rsyaRate,
                                        String countersRate, String goalsRate, String clickVisitRate,
                                        BigDecimal metrikaAmount, BigDecimal metrikaAndGoalsAmount,
                                        BigDecimal autobudgetAmount,
                                        BigDecimal autotargetSearchAmount) {
        this(contractEids, clientId, clientLogin, clientName, representativeLogin,
                cid, campaignName, totalAmount,
                rsyaAmount, rsyaRate,
                null, null, null, null,
                countersRate, goalsRate, clickVisitRate, metrikaAmount, metrikaAndGoalsAmount, autobudgetAmount,
                null, null, null, null,
                null, null, null, autotargetSearchAmount);
    }

    public BigDecimal getRsyaAmount() {
        return rsyaAmount;
    }

    public BigDecimal getRsyaRate() {
        return rsyaRate;
    }

    public String getDomainName() {
        return domainName;
    }

    public String getDomainTotalAmount() {
        return domainTotalAmount;
    }

    public String getDomainRsyaAmount() {
        return domainRsyaAmount;
    }

    public String getDomainRsyaRate() {
        return domainRsyaRate;
    }

    public String getCountersRate() {
        return countersRate;
    }

    public String getGoalsRate() {
        return goalsRate;
    }

    public String getClickVisitRate() {
        return clickVisitRate;
    }

    public BigDecimal getMetrikaAmount() {
        return metrikaAmount;
    }

    public BigDecimal getMetrikaAndGoalsAmount() {
        return metrikaAndGoalsAmount;
    }

    public BigDecimal getAutobudgetAmount() {
        return autobudgetAmount;
    }

    public BigDecimal getCpcVideoAmount() {
        return cpcVideoAmount;
    }

    public BigDecimal getMobileContentAmount() {
        return mobileContentAmount;
    }

    public BigDecimal getPerformanceAmount() {
        return performanceAmount;
    }

    public BigDecimal getProductGalleryAmount() {
        return productGalleryAmount;
    }

    public String getK50EffectiveActionsRate() {
        return k50EffectiveActionsRate;
    }

    public String getK50EfficientAmount() {
        return k50EfficientAmount;
    }

    public BigDecimal getRetargetingAmount() {
        return retargetingAmount;
    }

    public BigDecimal getAutotargetSearchAmount() {
        return autotargetSearchAmount;
    }
}
