package ru.yandex.direct.jobs.offlinereport.model.domain;

import java.util.Map;

public class DomainOfflineReportRow {
    private final String domain;//домен
    private final Long clientId;//id клиента
    private final String clientName;//название клиента
    //данные на каждый месяц. Хэш таблица код месяца вида 201903 в модель данных
    private final Map<String, DomainOfflineReportRowCal> cal;

    public DomainOfflineReportRow(String domain, Long clientId, String clientName,
                                  Map<String, DomainOfflineReportRowCal> cal) {
        this.domain = domain;
        this.clientId = clientId;
        this.clientName = clientName;
        this.cal = cal;
    }

    public String getDomain() {
        return domain;
    }

    public Long getClientId() {
        return clientId;
    }

    public String getClientName() {
        return clientName;
    }

    public Map<String, DomainOfflineReportRowCal> getCal() {
        return cal;
    }
}
