package ru.yandex.direct.jobs.payment;

import java.time.Duration;

class TurnOnAutopayUtils {

    private TurnOnAutopayUtils() {
    }

    static final int MAX_ATTEMPTS = 26;

    private static final int MIN_RETRY_STEP = 5;
    private static final int STEPS_IN_BATCH = 4;

    static Duration calcTryLater(Long tryCount) {
        long batch = tryCount / STEPS_IN_BATCH;
        return Duration.ofSeconds(MIN_RETRY_STEP * ((long) Math.pow(2, batch)));
    }
}
