package ru.yandex.direct.jobs.permalinks;

import java.util.Map;

import one.util.streamex.StreamEx;

import static java.util.function.Function.identity;

/**
 * Тип изменений записи с пермалинком (добавление/удаление)
 */
public enum DiffTableChangeType {
    ADDED(1),
    DELETED(-1),
    ;

    private static final Map<Integer, DiffTableChangeType> CHANGE_TYPE_BY_VALUE = StreamEx
            .of(DiffTableChangeType.values())
            .toMap(DiffTableChangeType::getValue, identity());
    private final int value;

    public static DiffTableChangeType parse(int value) {
        DiffTableChangeType changeType = CHANGE_TYPE_BY_VALUE.get(value);
        if (changeType == null) {
            throw new RuntimeException("");
        }
        return changeType;
    }

    DiffTableChangeType(int value) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }
}
