package ru.yandex.direct.jobs.permalinks;

import ru.yandex.direct.dbschema.ppc.tables.records.BannerPermalinksRecord;
import ru.yandex.inside.yt.kosher.impl.ytree.object.YTreeSerializer;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeField;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeObject;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeSerializerClass;
import ru.yandex.inside.yt.kosher.tables.YTableEntryType;
import ru.yandex.inside.yt.kosher.tables.YTableEntryTypes;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;
import ru.yandex.type_info.TiType;
import ru.yandex.yson.YsonConsumer;

import static ru.yandex.direct.dbschema.ppc.enums.BannerPermalinksPermalinkAssignType.auto;

/**
 * Представление одной строки в дифф-таблице между новыми
 * автопермалинками Справочника и текущими автопермалинками в Директе.
 */
@YTreeObject
class DiffTableRow {
    static final YTableEntryType<DiffTableRow> YT_TYPE = YTableEntryTypes.yson(DiffTableRow.class);
    private static final String BID_FIELD_NAME = "bid";
    private static final String CHANGE_TYPE_FIELD_NAME = "change_type";
    private static final String PERMALINK_FIELD_NAME = "permalink";
    private static final String CHAIN_ID_FIELD_NAME = "chain_id";

    @YTreeField(key = BID_FIELD_NAME)
    private final Long bid;
    @YTreeField(key = CHANGE_TYPE_FIELD_NAME)
    @YTreeSerializerClass(ChangeTypeSerializer.class)
    private final DiffTableChangeType changeType;
    @YTreeField(key = PERMALINK_FIELD_NAME)
    private final Long permalink;
    @YTreeField(key = CHAIN_ID_FIELD_NAME)
    private final Long chainId;

    public DiffTableRow(Long bid, DiffTableChangeType changeType, Long permalink, Long chainId) {
        this.bid = bid;
        this.changeType = changeType;
        this.permalink = permalink;
        this.chainId = chainId;
    }

    public static BannerPermalinksRecord toBannerPermalinksRecord(DiffTableRow row) {
        BannerPermalinksRecord result = new BannerPermalinksRecord();
        result.setBid(row.getBid());
        result.setPermalink(row.getPermalink());
        result.setChainId(row.getChainId());
        result.setPermalinkAssignType(auto);
        return result;
    }

    public Long getBid() {
        return bid;
    }

    public DiffTableChangeType getChangeType() {
        return changeType;
    }

    public Long getPermalink() {
        return permalink;
    }

    public Long getChainId() {
        return chainId;
    }

    public static class ChangeTypeSerializer implements YTreeSerializer<DiffTableChangeType> {

        @Override
        public void serialize(DiffTableChangeType obj, YsonConsumer consumer) {
        }

        @Override
        public DiffTableChangeType deserialize(YTreeNode node) {
            return DiffTableChangeType.parse(node.intValue());
        }

        @Override
        public TiType getColumnValueType() {
            return TiType.optional(TiType.yson());
        }
    }
}
