package ru.yandex.direct.jobs.permalinks;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.repository.BannerTypedRepository;
import ru.yandex.direct.core.entity.bs.resync.queue.repository.BsResyncQueueRepository;
import ru.yandex.direct.core.entity.organizations.repository.OrganizationRepository;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.ytwrapper.client.YtProvider;
import ru.yandex.direct.ytwrapper.model.YtCluster;
import ru.yandex.inside.yt.kosher.cypress.YPath;

@Lazy
@Component
@ParametersAreNonnullByDefault
class SingleShardProcessorFactory {
    private final YtProvider ytProvider;
    private final OrganizationRepository organizationRepository;
    private final BannerTypedRepository bannerTypedRepository;
    private final BsResyncQueueRepository bsResyncQueueRepository;
    private final ShardHelper shardHelper;

    @Autowired
    SingleShardProcessorFactory(YtProvider ytProvider,
                                OrganizationRepository organizationRepository,
                                BannerTypedRepository bannerTypedRepository,
                                BsResyncQueueRepository bsResyncQueueRepository,
                                ShardHelper shardHelper) {
        this.ytProvider = ytProvider;
        this.organizationRepository = organizationRepository;
        this.bannerTypedRepository = bannerTypedRepository;
        this.bsResyncQueueRepository = bsResyncQueueRepository;
        this.shardHelper = shardHelper;
    }

    SingleShardProcessor createProcessor(int shard, YtCluster cluster, YPath dataDir) {
        return new SingleShardProcessor(shard,
                shardHelper,
                ytProvider,
                cluster,
                dataDir,
                organizationRepository,
                bannerTypedRepository,
                bsResyncQueueRepository);
    }
}
