package ru.yandex.direct.jobs.permalinks;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;

import ru.yandex.direct.common.db.PpcPropertyNames;
import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.ytwrapper.model.YtCluster;
import ru.yandex.inside.yt.kosher.cypress.YPath;

/**
 * Конфиг для {@link UpdateBannerPermalinksJob}.
 */
@ParametersAreNonnullByDefault
class UpdateBannerPermalinksJobConfig {
    /**
     * Список кластеров, которые может использовать джоба.
     */
    private final List<YtCluster> clusters;
    /**
     * Путь к табличке Справочника.
     */
    private final YPath pathToAltayTable;
    /**
     * Максимально допустимое количество изменений за одну итерацию если пропертя
     * {@link PpcPropertyNames#ALLOW_MASS_ADD_REMOVE_PERMALINKS_IN_SYNC_JOB} отключена.
     */
    private final int maxChangesNumAllowed;

    private UpdateBannerPermalinksJobConfig(List<YtCluster> clusters,
                                            YPath pathToAltayTable,
                                            int maxChangesNumAllowed) {
        this.clusters = clusters;
        this.pathToAltayTable = pathToAltayTable;
        this.maxChangesNumAllowed = maxChangesNumAllowed;
    }

    static UpdateBannerPermalinksJobConfig createConfig(DirectConfig directConfig) {
        DirectConfig config = directConfig.getBranch("organizations-sync");
        List<YtCluster> clusters = StreamEx.of(config.getStringList("clusters"))
                .map(YtCluster::parse)
                .toList();
        YPath path = YPath.simple(config.getString("altay_table_path"));
        int maxChangesNumAllowed = config.getInt("max_changes_num_allowed");
        return new UpdateBannerPermalinksJobConfig(clusters, path, maxChangesNumAllowed);
    }

    List<YtCluster> getClusters() {
        return clusters;
    }

    YPath getPathToAltayTable() {
        return pathToAltayTable;
    }

    int getMaxChangesNumAllowed() {
        return maxChangesNumAllowed;
    }
}
