package ru.yandex.direct.jobs.placements;

import java.util.regex.Pattern;

import one.util.streamex.StreamEx;

import static com.google.common.base.Preconditions.checkArgument;

public final class CoordinatesUtils {

    public static final Pattern COORDINATES_PATTERN = Pattern.compile("^(\\d*\\.)?\\d+\\s*,\\s*(\\d*\\.)?\\d+$");

    private CoordinatesUtils() {
    }

    public static void checkCoordinates(String coordinates) {
        checkArgument(COORDINATES_PATTERN.matcher(coordinates).matches(),
                "Invalid coordinates: %s", coordinates);
    }

    public static String convertToGeosearchCoordinates(String coordinates) {
        checkCoordinates(coordinates);
        String[] latitudeLongitude = coordinates.split(",");
        return StreamEx.of(latitudeLongitude[1], latitudeLongitude[0])
                .map(String::trim)
                .joining(",");
    }
}
