package ru.yandex.direct.jobs.placements;

import java.util.Arrays;
import java.util.List;

import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.ytwrapper.model.YtCluster;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

/**
 * Работа с конфигурацией для {@link UpdatePlacementsJob}.
 * Пример конфига:
 * <p>
 * placements {
 * update {
 * clusters: [hahn, arnold]
 * table_path: "//home/yabs/dict/EditPage"
 * }
 * }
 */
public class UpdatePlacementsConfig {

    private final DirectConfig directConfig;
    private final Table updatePlacementsTable;

    private UpdatePlacementsConfig(DirectConfig directConfig) {
        this.directConfig = directConfig;
        updatePlacementsTable = new Table("update");
    }

    public static UpdatePlacementsConfig createUpdatePlacementsConfig(DirectConfig directConfig) {
        DirectConfig config = directConfig.getBranch("placements");
        return new UpdatePlacementsConfig(config);
    }

    /**
     * Описание параметров таблицы YT
     */
    public class Table {
        protected final DirectConfig config;

        Table(String branch) {
            this.config = directConfig.getBranch(branch);
        }

        /**
         * Кластер YT
         */
        public List<YtCluster> clusters() {
            return mapList(config.getStringList("clusters"), s -> YtCluster.valueOf(s.toUpperCase()));
        }

        /**
         * Путь до таблицы в YT
         */
        public String path() {
            return config.getString("table_path");
        }

        @Override
        public String toString() {
            return "Table{" +
                    Arrays.toString(mapList(clusters(), Enum::name).toArray(new String[0])) +
                    ".[" + path() + "]" +
                    "}";
        }
    }

    /**
     * Таблица, в которую складываются обновления данных о площадках от Adfox
     */
    public Table updatePlacementsTable() {
        return updatePlacementsTable;
    }
}
