package ru.yandex.direct.jobs.placements.container;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.placements.model1.PlacementPhoto;

public class YtIndoorBlock extends YtCommonBlock {

    @JsonProperty("Address")
    private String address;

    @JsonProperty("GPS")
    private String gps;

    @JsonProperty("Resolution")
    private String resolution;

    @JsonProperty("FacilityType")
    private Integer facilityType;

    @JsonProperty("ZoneCategory")
    private Integer zoneCategory;

    @JsonProperty("AspectRatio")
    private List<Integer> aspectRatio;

    @JsonProperty("PhotoList")
    private List<PlacementPhoto> photos;

    @JsonProperty("IsHidden")
    private Boolean hidden;

    @Override
    public YtIndoorBlock withId(Long id) {
        return (YtIndoorBlock) super.withId(id);
    }

    @Override
    public YtIndoorBlock withSizes(List<YtBlockSize> sizes) {
        return (YtIndoorBlock) super.withSizes(sizes);
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public YtIndoorBlock withAddress(String address) {
        this.address = address;
        return this;
    }

    public String getGps() {
        return gps;
    }

    public void setGps(String gps) {
        this.gps = gps;
    }

    public YtIndoorBlock withGps(String gps) {
        this.gps = gps;
        return this;
    }

    public String getResolution() {
        return resolution;
    }

    public void setResolution(String resolution) {
        this.resolution = resolution;
    }

    public YtIndoorBlock withResolution(String resolution) {
        this.resolution = resolution;
        return this;
    }

    public Integer getFacilityType() {
        return facilityType;
    }

    public YtIndoorBlock withFacilityType(Integer facilityType) {
        this.facilityType = facilityType;
        return this;
    }

    public Integer getZoneCategory() {
        return zoneCategory;
    }

    public YtIndoorBlock withZoneCategory(Integer zoneCategory) {
        this.zoneCategory = zoneCategory;
        return this;
    }

    public List<Integer> getAspectRatio() {
        return aspectRatio;
    }

    public YtIndoorBlock withAspectRatio(List<Integer> aspectRatio) {
        this.aspectRatio = aspectRatio;
        return this;
    }

    public List<PlacementPhoto> getPhotos() {
        return photos;
    }

    public YtIndoorBlock withPhotos(List<PlacementPhoto> photos) {
        this.photos = photos;
        return this;
    }

    public Boolean getHidden() {
        return hidden;
    }

    public YtIndoorBlock withHidden(Boolean hidden) {
        this.hidden = hidden;
        return this;
    }
}
