package ru.yandex.direct.jobs.placements.container;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.placements.model1.PlacementPhoto;

public class YtOutdoorBlock extends YtCommonBlock {

    @JsonProperty("Address")
    private String address;

    @JsonProperty("GPS")
    private String gps;

    @JsonProperty("Resolution")
    private String resolution;

    @JsonProperty("FacilityType")
    private Integer facilityType;

    @JsonProperty("Direction")
    private Integer direction;

    @JsonProperty("Width")
    private Double width;

    @JsonProperty("Height")
    private Double height;

    @JsonProperty("MinDuration")
    private Double minDuration;

    @JsonProperty("PhotoList")
    private List<PlacementPhoto> photos;

    @JsonProperty("IsHidden")
    private Boolean hidden;

    @Override
    public YtOutdoorBlock withId(Long id) {
        return (YtOutdoorBlock) super.withId(id);
    }

    @Override
    public YtOutdoorBlock withBlockCaption(String blockCaption) {
        return (YtOutdoorBlock) super.withBlockCaption(blockCaption);
    }

    @Override
    public YtOutdoorBlock withSizes(List<YtBlockSize> sizes) {
        return (YtOutdoorBlock) super.withSizes(sizes);
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public YtOutdoorBlock withAddress(String address) {
        this.address = address;
        return this;
    }

    public String getGps() {
        return gps;
    }

    public void setGps(String gps) {
        this.gps = gps;
    }

    public YtOutdoorBlock withGps(String gps) {
        this.gps = gps;
        return this;
    }

    public String getResolution() {
        return resolution;
    }

    public void setResolution(String resolution) {
        this.resolution = resolution;
    }

    public YtOutdoorBlock withResolution(String resolution) {
        this.resolution = resolution;
        return this;
    }

    public Integer getFacilityType() {
        return facilityType;
    }

    public YtOutdoorBlock withFacilityType(Integer facilityType) {
        this.facilityType = facilityType;
        return this;
    }

    public Integer getDirection() {
        return direction;
    }

    public YtOutdoorBlock withDirection(Integer direction) {
        this.direction = direction;
        return this;
    }

    public Double getWidth() {
        return width;
    }

    public YtOutdoorBlock withWidth(Double width) {
        this.width = width;
        return this;
    }

    public Double getHeight() {
        return height;
    }

    public YtOutdoorBlock withHeight(Double height) {
        this.height = height;
        return this;
    }

    public Double getMinDuration() {
        return minDuration;
    }

    public YtOutdoorBlock withMinDuration(Double minDuration) {
        this.minDuration = minDuration;
        return this;
    }

    public List<PlacementPhoto> getPhotos() {
        return photos;
    }

    public YtOutdoorBlock withPhotos(List<PlacementPhoto> photos) {
        this.photos = photos;
        return this;
    }

    public Boolean getHidden() {
        return hidden;
    }

    public YtOutdoorBlock withHidden(Boolean hidden) {
        this.hidden = hidden;
        return this;
    }

}
