package ru.yandex.direct.jobs.placements.validation;

import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectId;

public class PlacementDefects {

    public enum Gen implements DefectId<Void> {
        NO_TRANSLATION,
        UNKNOWN_OPERATOR,
        NO_DETERMINED_INTERNAL_NAME,
    }

    private PlacementDefects() {
    }

    public static Defect<Void> noTranslation() {
        return new Defect<>(Gen.NO_TRANSLATION);
    }

    public static Defect<Void> unknownOperator() {
        return new Defect<>(Gen.UNKNOWN_OPERATOR);
    }

    public static Defect<Void> noDeterminedInternalName() {
        return new Defect<>(Gen.NO_DETERMINED_INTERNAL_NAME);
    }
}
