package ru.yandex.direct.jobs.postviewofflinereport

import org.apache.poi.ss.usermodel.Workbook
import org.springframework.stereotype.Service
import ru.yandex.direct.common.mds.MdsHolder
import ru.yandex.direct.core.entity.mdsfile.model.MdsFileCustomName
import ru.yandex.direct.core.entity.mdsfile.model.MdsFileMetadata
import ru.yandex.direct.core.entity.mdsfile.model.MdsStorageType
import ru.yandex.direct.core.entity.mdsfile.repository.MdsFileRepository
import ru.yandex.direct.core.entity.mdsfile.service.MdsFileService
import ru.yandex.direct.dbutil.model.ClientId
import ru.yandex.direct.utils.HashingUtils
import ru.yandex.misc.io.ByteArrayInputStreamSource
import java.io.ByteArrayOutputStream
import java.io.IOException

@Service
class PostViewOfflineReportXlsUploader(
    private val mdsHolder: MdsHolder,
    private val mdsFileRepository: MdsFileRepository,
) {
    private val mdsStorageHost = MdsFileService.getStorageHost(mdsHolder)

    companion object {
        private val EXPIRE_DURATION = org.joda.time.Duration.standardDays(92L) // iceberg mds хочет такой класс
    }

    fun uploadFile(
        shard: Int,
        clientId: ClientId,
        reportId: Long,
        workbook: Workbook,

    ) : String {
        val byteData = toBytes(workbook)
        val hash = HashingUtils.getMd5HashAsBase64YaStringWithoutPadding(byteData)
        val mdsPath = "postview-report/$hash/$reportId"
        val mdsPostResponse = mdsHolder.upload(mdsPath, ByteArrayInputStreamSource(byteData), EXPIRE_DURATION)

        val mdsMetadata = MdsFileMetadata()
            .withClientId(clientId.asLong())
            .withFileImprint(hash)
            .withFilename(hash)
            .withSize(mdsPostResponse.size)
            .withStorageHost(mdsStorageHost)
            .withMdsKey(mdsPostResponse.key.toString())
            .withType(MdsStorageType.OFFLINE_STAT_REPORTS)

        mdsFileRepository.addMetadata(shard, listOf(mdsMetadata))

        val customName = MdsFileCustomName()
            .withFilename("$reportId.xlsx")
            .withMdsId(mdsMetadata.id)
        mdsFileRepository.addCustomName(shard, listOf(customName))

        return customName.filename
    }

    private fun toBytes(workbook: Workbook): ByteArray {
        try {
            ByteArrayOutputStream().use { os ->
                workbook.write(os)
                return os.toByteArray()
            }
        } catch (e: IOException) {
            throw RuntimeException("Couldn't get bytes from workbook")
        }
    }
}
