package ru.yandex.direct.jobs.ppcdataexport.model;

import java.io.File;
import java.time.Duration;
import java.util.List;
import java.util.Set;

import com.typesafe.config.Config;

import ru.yandex.direct.ansiblejuggler.model.notifications.NotificationMethod;
import ru.yandex.direct.juggler.check.model.CheckTag;
import ru.yandex.direct.ytwrapper.model.YtCluster;

import static ru.yandex.direct.utils.FunctionalUtils.listToSet;


public class PpcDataExportInfo {

    private final String yqlFilePath;
    private final Duration deltaTime;
    private final String destinationTableRelativePath;
    private final Duration jugglerTtl;
    private final Set<CheckTag> jugglerCheckTags;
    private final YtCluster ytCluster;
    private final List<String> notificationRecipients;
    private final NotificationMethod[] notificationMethods;
    private final String solomonFlow;
    private final SolomonMode solomonMode;

    public PpcDataExportInfo(Config config, String confFilePath, YtCluster ytCluster) {
        this.ytCluster = ytCluster;

        int lastSlashIndex = confFilePath.lastIndexOf(File.separator) + 1;
        String yqlFileName = config.getString(SourceProperty.YQL_FILE_NAME);
        this.yqlFilePath = confFilePath.substring(0, lastSlashIndex) + yqlFileName;

        this.deltaTime = config.getDuration(SourceProperty.DELTA_TIME);
        this.destinationTableRelativePath = (config.hasPath(SourceProperty.DESTINATION_TABLE_RELATIVE_PATH)) ?
                config.getString(SourceProperty.DESTINATION_TABLE_RELATIVE_PATH) : null;

        this.jugglerTtl = config.getDuration(SourceProperty.JUGGLER_TTL);
        this.jugglerCheckTags =
                listToSet(config.getStringList(SourceProperty.JUGGLER_CHECK_TAGS), CheckTag::valueOf);

        this.notificationRecipients = config.getStringList(SourceProperty.NOTIFICATION_RECIPIENTS);
        this.notificationMethods = config.getStringList(SourceProperty.NOTIFICATION_METHODS)
                .stream()
                .map(NotificationMethod::valueOf)
                .toArray(NotificationMethod[]::new);
        this.solomonFlow = (config.hasPath(SourceProperty.SOLOMON_FLOW)) ?
                config.getString(SourceProperty.SOLOMON_FLOW) : null;
        this.solomonMode = (config.hasPath(SourceProperty.SOLOMON_MODE)) ?
                SolomonMode.valueOf(config.getString(SourceProperty.SOLOMON_MODE).toUpperCase()) : SolomonMode.SIMPLE;
    }


    private static class SourceProperty {
        static final String YQL_FILE_NAME = "yqlFileName";
        static final String DELTA_TIME = "deltaTime";
        static final String DESTINATION_TABLE_RELATIVE_PATH = "destinationTableRelativePath";
        static final String JUGGLER_TTL = "jugglerTtl";
        static final String JUGGLER_CHECK_TAGS = "jugglerCheckTags";
        static final String NOTIFICATION_METHODS = "notificationMethods";
        static final String NOTIFICATION_RECIPIENTS = "notificationRecipients";
        static final String SOLOMON_FLOW = "solomonFlow";
        static final String SOLOMON_MODE = "solomonMode";

        private SourceProperty() {
        }
    }

    public String getYqlFilePath() {
        return yqlFilePath;
    }

    public Duration getDeltaTime() {
        return deltaTime;
    }

    public String getDestinationTableRelativePath() {
        return destinationTableRelativePath;
    }

    public Duration getJugglerTtl() {
        return jugglerTtl;
    }

    public Set<CheckTag> getJugglerCheckTags() {
        return jugglerCheckTags;
    }

    public YtCluster getYtCluster() {
        return ytCluster;
    }

    public List<String> getNotificationRecipients() {
        return notificationRecipients;
    }

    public NotificationMethod[] getNotificationMethods() {
        return notificationMethods;
    }

    public String getSolomonFlow() {
        return solomonFlow;
    }

    public SolomonMode getSolomonMode() {
        return solomonMode;
    }

}
