package ru.yandex.direct.jobs.ppcdataexport.model;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;

import ru.yandex.direct.env.EnvironmentCondition;
import ru.yandex.direct.env.NonDevelopmentEnvironment;
import ru.yandex.direct.ytwrapper.model.YtCluster;

import static ru.yandex.direct.utils.FunctionalUtils.listToSet;

/**
 * Класс используется при старте приложения jobs, для того чтобы создать параметризованные джобы PpcDataExportJob
 */
public class PpcDataExportInitInfo {

    private static final Class<? extends EnvironmentCondition> DEFAULT_ENV_CONDITION = NonDevelopmentEnvironment.class;
    private static final String ENVIRONMENTS_PACKAGE = DEFAULT_ENV_CONDITION.getPackageName();

    private final Class<EnvironmentCondition> environmentCondition;
    private final Set<YtCluster> ytClusters;
    private final String confFilePath;

    public PpcDataExportInitInfo(Config config, String confFilePath, List<YtCluster> defaultYtClusters) {
        this.environmentCondition = resolveEnvironmentCondition(config);
        this.confFilePath = confFilePath;

        if (config.hasPath(SourceProperty.YT_CLUSTERS)) {
            this.ytClusters = listToSet(config.getStringList(SourceProperty.YT_CLUSTERS), s -> YtCluster.valueOf(s.toUpperCase()));
        } else {
            this.ytClusters = new HashSet<>(defaultYtClusters);
        }
    }

    @SuppressWarnings("unchecked")
    private Class<EnvironmentCondition> resolveEnvironmentCondition(Config config) {
        try {
            return (Class<EnvironmentCondition>) Class.forName(
                    ENVIRONMENTS_PACKAGE + "." + config.getString(SourceProperty.ENVIRONMENT_CONDITION)
            );
        } catch (ClassNotFoundException | ConfigException.Missing e) {
            return (Class<EnvironmentCondition>) DEFAULT_ENV_CONDITION;
        }
    }

    private static class SourceProperty {
        static final String ENVIRONMENT_CONDITION = "environmentCondition";
        static final String YT_CLUSTERS = "ytClusters";

        private SourceProperty() {
        }
    }

    public Class<EnvironmentCondition> getEnvironmentCondition() {
        return environmentCondition;
    }

    public Set<YtCluster> getYtClusters() {
        return ytClusters;
    }

    public String getConfFilePath() {
        return confFilePath;
    }
}
