package ru.yandex.direct.jobs.promocodes;

import java.time.LocalDateTime;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.ansiblejuggler.model.notifications.NotificationMethod;
import ru.yandex.direct.core.entity.promocodes.repository.PromocodeDomainsRepository;
import ru.yandex.direct.env.ProductionOnly;
import ru.yandex.direct.env.TypicalEnvironment;
import ru.yandex.direct.juggler.JugglerStatus;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.juggler.check.annotation.OnChangeNotification;
import ru.yandex.direct.juggler.check.model.CheckTag;
import ru.yandex.direct.scheduler.Hourglass;
import ru.yandex.direct.scheduler.support.DirectJob;

import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_PRIORITY_2;
import static ru.yandex.direct.juggler.check.model.NotificationRecipient.CHAT_INTERNAL_SYSTEMS_MONITORING;

@Hourglass(cronExpression = "0 30 5 * * ?", needSchedule = TypicalEnvironment.class)
@JugglerCheck(ttl = @JugglerCheck.Duration(days = 3),
        tags = {DIRECT_PRIORITY_2, CheckTag.GROUP_INTERNAL_SYSTEMS,
        },
        notifications = {@OnChangeNotification(recipient = CHAT_INTERNAL_SYSTEMS_MONITORING,
                status = {JugglerStatus.OK,
                        JugglerStatus.CRIT,
                },
                method = NotificationMethod.TELEGRAM),
        },
        needCheck = ProductionOnly.class)
public class PromocodeDomainsCleanupJob extends DirectJob {
    private static final Logger logger = LoggerFactory.getLogger(PromocodeDomainsCleanupJob.class);
    private static final int DAYS_TTL = 93; // три месяца с запасом
    private final PromocodeDomainsRepository repository;

    @Autowired
    public PromocodeDomainsCleanupJob(PromocodeDomainsRepository repository) {
        this.repository = repository;
     }

    @Override
    public void execute() {
        LocalDateTime time = LocalDateTime.now().minusDays(DAYS_TTL);
        logger.info("Will delete rows older than {}", time);
        int cntRows = repository.deleteOldPromocodeDomains(time);
        logger.info("Deleted {} rows", cntRows);
    }
}
