package ru.yandex.direct.jobs.receiveorganizationstatuschanges.logbroker;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.TextFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.altay.direct.Direct;
import ru.yandex.direct.binlogbroker.logbroker_utils.reader.impl.LogbrokerBatchReaderImpl;
import ru.yandex.kikimr.persqueue.consumer.SyncConsumer;
import ru.yandex.kikimr.persqueue.consumer.transport.message.inbound.data.MessageBatch;
import ru.yandex.kikimr.persqueue.consumer.transport.message.inbound.data.MessageData;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

@ParametersAreNonnullByDefault
public class OrganizationsStatusChangeLogbrokerReader extends LogbrokerBatchReaderImpl<Direct.ChangedPermalinkStatus> {

    private static final Logger logger = LoggerFactory.getLogger(OrganizationsStatusChangeLogbrokerReader.class);

    public OrganizationsStatusChangeLogbrokerReader(Supplier<SyncConsumer> logbrokerConsumerSupplier,
                                                    boolean logbrokerNoCommit) {
        super(logbrokerConsumerSupplier, logbrokerNoCommit);
    }

    public OrganizationsStatusChangeLogbrokerReader(Supplier<SyncConsumer> logbrokerConsumerSupplier,
                                                    boolean logbrokerNoCommit,
                                                    MetricRegistry metricRegistry) {
        super(logbrokerConsumerSupplier, logbrokerNoCommit, metricRegistry);
    }

    @Override
    protected List<Direct.ChangedPermalinkStatus> batchDeserialize(MessageBatch messageBatch) {
        List<Direct.ChangedPermalinkStatus> data = new ArrayList<>();

        for (MessageData messageData : messageBatch.getMessageData()) {
            Direct.ChangedPermalinkStatus changedPermalinkStatus;
            try {
                changedPermalinkStatus = Direct.ChangedPermalinkStatus.parseFrom(messageData.getDecompressedData());
            } catch (InvalidProtocolBufferException e) {
                logger.error("Got error parsing message", e);
                continue;
            }

            logger.info("Object - {}", TextFormat.shortDebugString(changedPermalinkStatus));

            data.add(changedPermalinkStatus);
        }

        return data;
    }

    @Override
    protected int count(List<Direct.ChangedPermalinkStatus> e) {
        return e.size();
    }
}
