package ru.yandex.direct.jobs.receiveorganizationstatuschanges.logbroker;

import java.util.Collections;
import java.util.function.Supplier;

import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.ess.common.logbroker.LogbrokerConsumerProperties;
import ru.yandex.direct.ess.common.logbroker.LogbrokerConsumerPropertiesImpl;
import ru.yandex.direct.tvm.TvmIntegration;
import ru.yandex.direct.tvm.TvmService;
import ru.yandex.kikimr.persqueue.auth.Credentials;
import ru.yandex.monlib.metrics.labels.Labels;

public class ReceiveChangesLogbrokerUtils {

    public static LogbrokerConsumerProperties createConsumerProperties(DirectConfig organizationsConfig) {
        return new LogbrokerConsumerPropertiesImpl.Builder()
                .setHost(organizationsConfig.getString("host"))
                .setReadDataTimeoutSec(organizationsConfig.getLong("data_timeout"))
                .setInitTimeoutSec(organizationsConfig.getLong("init_timeout"))
                .setRetries(organizationsConfig.getInt("retries"))
                .setGroups(Collections.singletonList(organizationsConfig.getInt("group")))

                .setReadTopic(organizationsConfig.getString("topic"))
                .setConsumerName(organizationsConfig.getString("client_id"))
                .build();
    }

    public static Supplier<Credentials> createCredentialsSupplier(DirectConfig organizationsConfig,
                                                                  TvmIntegration tvmIntegration) {
        String logbrokerTvmServiceName = organizationsConfig.getString("tvm_service_name");
        TvmService logbrokerTvmService = TvmService.fromStringStrict(logbrokerTvmServiceName);

        return () -> {
            String serviceTicket = tvmIntegration.getTicket(logbrokerTvmService);
            return Credentials.tvm(serviceTicket);
        };
    }

    public static Labels createSolomonRegistryLabels(String label, String topicName) {
        return Labels.of(
                "jobs", label,
                "topic", topicName);
    }
}
