package ru.yandex.direct.jobs.recommendations;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.env.NonProductionEnvironment;
import ru.yandex.direct.env.ProductionOnly;
import ru.yandex.direct.jobs.configuration.RecommendationsApplicationParametersSource;
import ru.yandex.direct.jobs.interceptors.IgnoreStartFinishLogging;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.scheduler.Hourglass;
import ru.yandex.direct.scheduler.HourglassDaemon;
import ru.yandex.direct.scheduler.HourglassStretchingDisabled;
import ru.yandex.direct.scheduler.support.DirectParameterizedJob;
import ru.yandex.direct.scheduler.support.ParameterizedBy;
import ru.yandex.direct.ytcore.entity.recommendation.service.RecommendationService;

import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_PRIORITY_0;
import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_PRODUCT_TEAM;
import static ru.yandex.direct.juggler.check.model.CheckTag.GROUP_INTERNAL_SYSTEMS;
import static ru.yandex.direct.juggler.check.model.CheckTag.JOBS_RELEASE_REGRESSION;

/**
 * Джоба применения рекомендаций.
 */
@HourglassDaemon(runPeriod = 1)

@Hourglass(periodInSeconds = 1)
@HourglassStretchingDisabled

@JugglerCheck(ttl = @JugglerCheck.Duration(minutes = 5), needCheck = ProductionOnly.class, tags = {DIRECT_PRIORITY_0, GROUP_INTERNAL_SYSTEMS, DIRECT_PRODUCT_TEAM})
@JugglerCheck(ttl = @JugglerCheck.Duration(minutes = 5), needCheck = NonProductionEnvironment.class, tags = {DIRECT_PRIORITY_0, GROUP_INTERNAL_SYSTEMS,
        JOBS_RELEASE_REGRESSION})
@IgnoreStartFinishLogging
@ParameterizedBy(parametersSource = RecommendationsApplicationParametersSource.class)
@ParametersAreNonnullByDefault
public class RecommendationsApplyJob extends DirectParameterizedJob<WorkerInfo> {
    private final RecommendationsApplicationParametersSource parametersSource;
    private final RecommendationService recommendationService;

    @Autowired
    public RecommendationsApplyJob(RecommendationsApplicationParametersSource parametersSource,
                                   RecommendationService recommendationService) {
        this.parametersSource = parametersSource;
        this.recommendationService = recommendationService;
    }

    @Override
    public void execute() {
        WorkerInfo workerInfo = parametersSource.convertStringToParam(getParam());

        int shard = workerInfo.getShard();
        int parId = workerInfo.getWorkerNumber();

        recommendationService.processFromQueue(shard, parId);
    }
}
