package ru.yandex.direct.jobs.recommendations;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.env.NonProductionEnvironment;
import ru.yandex.direct.env.ProductionOnly;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.scheduler.Hourglass;
import ru.yandex.direct.scheduler.support.DirectShardedJob;
import ru.yandex.direct.ytcore.entity.recommendation.service.RecommendationService;

import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_PRIORITY_2;
import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_PRODUCT_TEAM;
import static ru.yandex.direct.juggler.check.model.CheckTag.GROUP_INTERNAL_SYSTEMS;
import static ru.yandex.direct.juggler.check.model.CheckTag.JOBS_RELEASE_REGRESSION;

/**
 * Джоба удаления устаревших рекомендаций из MySQL таблиц recommendations_status и recommendations_online.
 * Порог устаревания установлен в 4 дня.
 */
@Hourglass(cronExpression = "0 0/30 * * * ?") // каждые 30 минут
@JugglerCheck(ttl = @JugglerCheck.Duration(hours = 1), needCheck = ProductionOnly.class, tags = {DIRECT_PRIORITY_2, GROUP_INTERNAL_SYSTEMS, DIRECT_PRODUCT_TEAM})
@JugglerCheck(ttl = @JugglerCheck.Duration(hours = 1), needCheck = NonProductionEnvironment.class, tags = {DIRECT_PRIORITY_2, GROUP_INTERNAL_SYSTEMS,
        JOBS_RELEASE_REGRESSION})
public class RecommendationsCleanupJob extends DirectShardedJob {
    private final RecommendationService recommendationService;

    @Autowired
    public RecommendationsCleanupJob(
            RecommendationService recommendationService) {
        this.recommendationService = recommendationService;
    }


    @Override
    public void execute() {
        recommendationService.deleteOld(getShard());
    }
}
