package ru.yandex.direct.jobs.recommendations;

import java.util.Set;

import ru.yandex.inside.yt.kosher.cypress.YPath;

public class TableInfo {
    // Полный путь к таблице
    private final YPath path;
    // Откуда приехала таблица ("hahn", "arnold", итд)
    // Не специфицируем строго значения в этом поле, чтобы можно было легко добавлять новые источники
    private final String source;
    // Типы рекомендаций, хранящиеся в таблице
    private final Set<Integer> types;
    // Время генерации таблицы
    private final long timestamp;

    public TableInfo(YPath path, String source, Set<Integer> types, long timestamp) {
        this.path = path;
        this.source = source;
        this.types = types;
        this.timestamp = timestamp;
    }

    public YPath getPath() {
        return path;
    }

    public String getSource() {
        return source;
    }

    public Set<Integer> getTypes() {
        return types;
    }

    public long getTimestamp() {
        return timestamp;
    }
}
