package ru.yandex.direct.jobs.recommendations;

import com.google.common.base.Objects;
import org.apache.commons.lang3.StringUtils;

/**
 * Класс для сохранения в базе информации о воркере джобы рекомендаций
 */
public class WorkerInfo {
    private final int shard;

    private final int workerNumber;

    public WorkerInfo(int shard, int workerNumber) {
        this.shard = shard;
        this.workerNumber = workerNumber;
    }

    public int getShard() {
        return shard;
    }

    public int getWorkerNumber() {
        return workerNumber;
    }

    @Override
    public String toString() {
        return String.format("shard_%d_worker_%d", shard, workerNumber);
    }

    /**
     * Метод восстанавливает воркер сохраненный через toString()
     * То есть WorkerInfo.valueOf(workerInfo.toString) == workerInfo
     */
    public static WorkerInfo valueOf(String string) {
        int shard = Integer.valueOf(StringUtils.substringBetween(string, "_"));
        int workerNumber = Integer.valueOf(StringUtils.substringAfterLast(string, "_"));
        return new WorkerInfo(shard, workerNumber);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WorkerInfo)) {
            return false;
        }
        WorkerInfo that = (WorkerInfo) o;
        return Objects.equal(shard, that.shard) &&
                Objects.equal(workerNumber, that.workerNumber);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(shard, workerNumber);
    }
}
