package ru.yandex.direct.jobs.recommendations;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;

import ru.yandex.inside.yt.kosher.ytree.YTreeNode;

import static ru.yandex.direct.grid.core.entity.recommendation.RecommendationTablesUtils.ACCESS_TIME;
import static ru.yandex.direct.grid.core.entity.recommendation.RecommendationTablesUtils.CREATION_TIME;
import static ru.yandex.direct.grid.core.entity.recommendation.RecommendationTablesUtils.MODIFICATION_TIME;

public class YtLastAccessTsLoader {

    private static final String YT_DATETIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'";
    private static final Set<String> DATETIME_ATTRS = ImmutableSet.of(CREATION_TIME, MODIFICATION_TIME, ACCESS_TIME);

    /**
     * Получает самый свежий timestamp использования таблицы
     */
    public long getLastAccessTs(YTreeNode node) {
        return Collections.max(Arrays.asList(
                getTimestampFromAttr(node, CREATION_TIME),
                getTimestampFromAttr(node, ACCESS_TIME),
                getTimestampFromAttr(node, MODIFICATION_TIME)));
    }

    /**
     * Получает для переданной ноды timestamp атрибута
     */
    private long getTimestampFromAttr(YTreeNode node, String nodeAttr) {
        Preconditions.checkState(DATETIME_ATTRS.contains(nodeAttr));
        try {
            DateFormat df = new SimpleDateFormat(YT_DATETIME_PATTERN);
            String target = node.getAttribute(nodeAttr).get().stringValue();
            return df.parse(target).toInstant().atZone(ZoneId.systemDefault()).toEpochSecond();
        } catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}
